/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfile;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfileEnrollmentResult;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfilePhraseResult;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfileResult;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfileType;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class VoiceProfileClient
implements AutoCloseable {
    private SafeHandle voiceProfileClientHandle = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    public VoiceProfileClient(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(this.createFromConfig(handle, speechConfig.getImpl()));
        this.voiceProfileClientHandle = new SafeHandle(handle.getValue(), SafeHandleType.VoiceProfileClient);
        this.initialize();
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<VoiceProfile> createProfileAsync(final VoiceProfileType voiceProfileType, final String locale) {
        return AsyncThreadService.submit(new Callable<VoiceProfile>(){

            @Override
            public VoiceProfile call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.createVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfileType.getValue(), locale, result));
                return new VoiceProfile(result.getValue());
            }
        });
    }

    public Future<VoiceProfileEnrollmentResult> enrollProfileAsync(final VoiceProfile voiceProfile, final AudioConfig audioConfig) {
        return AsyncThreadService.submit(new Callable<VoiceProfileEnrollmentResult>(){

            @Override
            public VoiceProfileEnrollmentResult call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.enrollVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getImpl(), audioConfig.getImpl(), result));
                return new VoiceProfileEnrollmentResult(result.getValue());
            }
        });
    }

    public Future<VoiceProfilePhraseResult> getActivationPhrasesAsync(final VoiceProfileType voiceProfileType, final String locale) {
        return AsyncThreadService.submit(new Callable<VoiceProfilePhraseResult>(){

            @Override
            public VoiceProfilePhraseResult call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.getActivationPhrases(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfileType.getValue(), locale, result));
                return new VoiceProfilePhraseResult(result.getValue());
            }
        });
    }

    public Future<VoiceProfileResult> deleteProfileAsync(final VoiceProfile voiceProfile) {
        return AsyncThreadService.submit(new Callable<VoiceProfileResult>(){

            @Override
            public VoiceProfileResult call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.deleteVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getImpl(), result));
                return new VoiceProfileResult(result.getValue());
            }
        });
    }

    public Future<VoiceProfileResult> resetProfileAsync(final VoiceProfile voiceProfile) {
        return AsyncThreadService.submit(new Callable<VoiceProfileResult>(){

            @Override
            public VoiceProfileResult call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.resetVoiceProfile(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getImpl(), result));
                return new VoiceProfileResult(result.getValue());
            }
        });
    }

    public Future<VoiceProfileEnrollmentResult> retrieveEnrollmentResultAsync(final VoiceProfile voiceProfile) {
        return AsyncThreadService.submit(new Callable<VoiceProfileEnrollmentResult>(){

            @Override
            public VoiceProfileEnrollmentResult call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.retrieveEnrollmentResult(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfile.getId(), voiceProfile.getType().getValue(), result));
                return new VoiceProfileEnrollmentResult(result.getValue());
            }
        });
    }

    public Future<List<VoiceProfile>> getAllProfilesAsync(final VoiceProfileType voiceProfileType) {
        return AsyncThreadService.submit(new Callable<List<VoiceProfile>>(){

            @Override
            public List<VoiceProfile> call() {
                ArrayList<VoiceProfile> profiles = new ArrayList<VoiceProfile>();
                StringRef profileListRef = new StringRef("");
                IntRef sizeRef = new IntRef(0L);
                Contracts.throwIfFail(VoiceProfileClient.this.getProfilesJson(VoiceProfileClient.this.voiceProfileClientHandle, voiceProfileType.getValue(), profileListRef, sizeRef));
                if (!profileListRef.getValue().isEmpty()) {
                    List<String> profileList = Arrays.asList(profileListRef.getValue().split("\\|"));
                    for (String prof : profileList) {
                        profiles.add(new VoiceProfile(prof, voiceProfileType));
                    }
                }
                return profiles;
            }
        });
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.voiceProfileClientHandle != null) {
            this.voiceProfileClientHandle.close();
            this.voiceProfileClientHandle = null;
        }
        AsyncThreadService.shutdown();
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.voiceProfileClientHandle;
    }

    private void initialize() {
        VoiceProfileClient _this = this;
        AsyncThreadService.initialize();
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromHandle(_this.voiceProfileClientHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private final native long createFromConfig(IntRef var1, SafeHandle var2);

    private final native long createVoiceProfile(SafeHandle var1, int var2, String var3, IntRef var4);

    private final native long getProfilesJson(SafeHandle var1, int var2, StringRef var3, IntRef var4);

    private final native long enrollVoiceProfile(SafeHandle var1, SafeHandle var2, SafeHandle var3, IntRef var4);

    private final native long deleteVoiceProfile(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long resetVoiceProfile(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long retrieveEnrollmentResult(SafeHandle var1, String var2, int var3, IntRef var4);

    private final native long getActivationPhrases(SafeHandle var1, int var2, String var3, IntRef var4);

    private final native long getPropertyBagFromHandle(SafeHandle var1, IntRef var2);
}

