/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.math.BigInteger;

public final class VoiceProfileEnrollmentResult
implements AutoCloseable {
    private SafeHandle resultHandle = null;
    private PropertyCollection properties = null;
    private String resultId = "";
    private ResultReason reason;
    private String profileId = "";
    private int enrollmentsCount = 0;
    private BigInteger enrollmentsLength;
    private int remainingEnrollmentsCount = 0;
    private BigInteger remainingEnrollmentsSpeechLength;
    private BigInteger audioLength;
    private BigInteger audioSpeechLength;
    private BigInteger enrollmentsSpeechLength;
    private String createdTime = "";
    private String lastUpdatedDateTime = "";

    VoiceProfileEnrollmentResult(long result) {
        this.resultHandle = new SafeHandle(result, SafeHandleType.VoiceProfileEnrollmentResult);
        StringRef stringVal = new StringRef("");
        Contracts.throwIfFail(this.getResultId(this.resultHandle, stringVal));
        this.resultId = stringVal.getValue();
        IntRef intVal = new IntRef(0L);
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intVal));
        this.reason = ResultReason.values()[(int)intVal.getValue()];
        IntRef propertyHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, propertyHandle));
        this.properties = new PropertyCollection(propertyHandle);
        this.profileId = this.properties.getProperty("enrollment.profileId");
        String value = this.properties.getProperty("enrollment.enrollmentsCount");
        this.enrollmentsCount = value.isEmpty() ? 0 : Integer.parseInt(value);
        value = this.properties.getProperty("enrollment.remainingEnrollmentsCount");
        this.remainingEnrollmentsCount = value.isEmpty() ? 0 : Integer.parseInt(value);
        value = this.properties.getProperty("enrollment.enrollmentsLengthInSec");
        this.enrollmentsLength = value.isEmpty() ? BigInteger.ZERO : new BigInteger(value);
        value = this.properties.getProperty("enrollment.remainingEnrollmentsSpeechLengthInSec");
        this.remainingEnrollmentsSpeechLength = value.isEmpty() ? BigInteger.ZERO : new BigInteger(value);
        value = this.properties.getProperty("enrollment.audioLengthInSec");
        this.audioLength = value.isEmpty() ? BigInteger.ZERO : new BigInteger(value);
        value = this.properties.getProperty("enrollment.audioSpeechLengthInSec");
        this.audioSpeechLength = value.isEmpty() ? BigInteger.ZERO : new BigInteger(value);
        value = this.properties.getProperty("enrollment.enrollmentsSpeechLengthInSec");
        this.enrollmentsSpeechLength = value.isEmpty() ? BigInteger.ZERO : new BigInteger(value);
        this.createdTime = this.properties.getProperty("enrollment.createdDateTime");
        this.lastUpdatedDateTime = this.properties.getProperty("enrollment.lastUpdatedDateTime");
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public int getEnrollmentsCount() {
        return this.enrollmentsCount;
    }

    public BigInteger getEnrollmentsLength() {
        return this.enrollmentsLength;
    }

    public int getRemainingEnrollmentsCount() {
        return this.remainingEnrollmentsCount;
    }

    public BigInteger getRemainingEnrollmentsSpeechLength() {
        return this.remainingEnrollmentsSpeechLength;
    }

    public BigInteger getAudioLength() {
        return this.audioLength;
    }

    public BigInteger getAudioSpeechLength() {
        return this.audioSpeechLength;
    }

    public BigInteger getEnrollmentsSpeechLength() {
        return this.enrollmentsSpeechLength;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    @Override
    public void close() {
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
    }

    public String toString() {
        return "ResultId:" + this.getResultId() + " Reason:" + (Object)((Object)this.getReason()) + " Json:" + this.properties.getProperty(PropertyId.SpeechServiceResponse_JsonResult);
    }

    public SafeHandle getImpl() {
        Contracts.throwIfNull(this.resultHandle, "result");
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);
}

