/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.CancellationErrorCode;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfilePhraseResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class VoiceProfilePhraseCancellationDetails {
    private CancellationReason reason;
    private String errorDetails;
    private CancellationErrorCode errorCode;

    public static VoiceProfilePhraseCancellationDetails fromResult(VoiceProfilePhraseResult result) {
        return new VoiceProfilePhraseCancellationDetails(result);
    }

    private VoiceProfilePhraseCancellationDetails(VoiceProfilePhraseResult result) {
        Contracts.throwIfNull(result, "result");
        Contracts.throwIfNull(result.getImpl(), "resultHandle");
        IntRef valueRef = new IntRef(0L);
        Contracts.throwIfFail(this.getCanceledReason(result.getImpl(), valueRef));
        this.reason = CancellationReason.values()[(int)valueRef.getValue() - 1];
        Contracts.throwIfFail(this.getCanceledErrorCode(result.getImpl(), valueRef));
        this.errorCode = CancellationErrorCode.values()[(int)valueRef.getValue()];
        this.errorDetails = result.getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonErrorDetails);
    }

    public CancellationReason getReason() {
        return this.reason;
    }

    public CancellationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "CancellationReason:" + (Object)((Object)this.reason) + " ErrorCode: " + (Object)((Object)this.errorCode) + " ErrorDetails:" + this.errorDetails;
    }

    private final native long getCanceledReason(SafeHandle var1, IntRef var2);

    private final native long getCanceledErrorCode(SafeHandle var1, IntRef var2);
}

