/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public final class VoiceProfileResult
implements AutoCloseable {
    private SafeHandle resultHandle = null;
    private PropertyCollection properties = null;
    private String resultId = "";
    private ResultReason reason;

    VoiceProfileResult(long result) {
        Contracts.throwIfNull(result, "result");
        this.resultHandle = new SafeHandle(result, SafeHandleType.VoiceProfileResult);
        StringRef stringVal = new StringRef("");
        Contracts.throwIfFail(this.getResultId(this.resultHandle, stringVal));
        this.resultId = stringVal.getValue();
        IntRef intVal = new IntRef(0L);
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intVal));
        this.reason = ResultReason.values()[(int)intVal.getValue()];
        IntRef propertyHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, propertyHandle));
        this.properties = new PropertyCollection(propertyHandle);
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
    }

    public String toString() {
        return "ResultId:" + this.getResultId() + " Reason:" + (Object)((Object)this.getReason()) + " Json:" + this.properties.getProperty(PropertyId.SpeechServiceResponse_JsonResult);
    }

    public SafeHandle getImpl() {
        Contracts.throwIfNull(this.resultHandle, "result");
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);
}

