/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class ConversationExpirationEventArgs
extends SessionEventArgs {
    private long minutesLeft;

    ConversationExpirationEventArgs(long eventArgs) {
        super(eventArgs);
        this.storeEventData(false);
    }

    ConversationExpirationEventArgs(long eventArgs, boolean dispose) {
        super(eventArgs);
        this.storeEventData(dispose);
    }

    public long getExpirationTime() {
        return this.minutesLeft;
    }

    @Override
    public String toString() {
        return "SessionId: " + this.getSessionId() + " Expiration: " + this.minutesLeft + ".";
    }

    private void storeEventData(boolean disposeNativeResources) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef errorHandle = new IntRef(0L);
        this.minutesLeft = this.getExpiration(this.eventHandle, errorHandle);
        Contracts.throwIfFail(errorHandle.getValue());
        if (disposeNativeResources) {
            super.close();
        }
    }

    private final native long getExpiration(SafeHandle var1, IntRef var2);
}

