/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.transcription.Conversation;
import com.microsoft.cognitiveservices.speech.transcription.ConversationExpirationEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.ConversationParticipantsChangedEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranslationCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranslationEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class ConversationTranslator
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<ConversationTranslationCanceledEventArgs> canceled = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationExpirationEventArgs> conversationExpiration = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationParticipantsChangedEventArgs> participantsChanged = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SessionEventArgs> sessionStarted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SessionEventArgs> sessionStopped = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationTranslationEventArgs> textMessageReceived = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationTranslationEventArgs> transcribed = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConversationTranslationEventArgs> transcribing = new EventHandlerImpl(this.eventCounter);
    static Set<ConversationTranslator> conversationTranslatorObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle translatorHandle = null;
    private final Object translatorLock = new Object();
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;
    private int activeAsyncRecognitionCounter = 0;
    private AudioConfig audioInputKeepAlive = null;

    public ConversationTranslator() {
        this(null);
    }

    public ConversationTranslator(AudioConfig audioConfig) {
        this.translatorHandle = new SafeHandle(0L, SafeHandleType.ConversationTranslator);
        this.audioInputKeepAlive = audioConfig;
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createConversationTranslatorFromConfig(this.translatorHandle, null));
        } else {
            Contracts.throwIfFail(this.createConversationTranslatorFromConfig(this.translatorHandle, audioConfig.getImpl()));
        }
        this.initialize();
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public Future<Void> joinConversationAsync(Conversation conversation, final String nickname) {
        final ConversationTranslator thisReco = this;
        final Conversation thisConv = conversation;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(thisReco.joinConversation(ConversationTranslator.this.translatorHandle, thisConv.getImpl(), nickname));
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> joinConversationAsync(final String conversationId, final String nickname, final String language) {
        final ConversationTranslator thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(thisReco.joinConversationId(ConversationTranslator.this.translatorHandle, conversationId, nickname, language));
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> leaveConversationAsync() {
        final ConversationTranslator thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(thisReco.leaveConversation(ConversationTranslator.this.translatorHandle));
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> sendTextMessageAsync(final String message) {
        final ConversationTranslator thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(thisReco.sendText(ConversationTranslator.this.translatorHandle, message));
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startTranscribingAsync() {
        final ConversationTranslator thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(thisReco.startTranscribing(ConversationTranslator.this.translatorHandle));
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopTranscribingAsync() {
        final ConversationTranslator thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(thisReco.stopTranscribing(ConversationTranslator.this.translatorHandle));
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public void setAuthorizationToken(String authToken, String region) {
        Contracts.throwIfNullOrWhitespace(authToken, "authToken");
        Contracts.throwIfNullOrWhitespace(region, "region");
        Contracts.throwIfFail(this.setAuthToken(this.translatorHandle, authToken, region));
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.translatorLock;
        synchronized (object) {
            if (this.activeAsyncRecognitionCounter != 0) {
                throw new IllegalStateException("Cannot dispose a conversationTranslator while async transcription is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public SafeHandle getImpl() {
        return this.translatorHandle;
    }

    private void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.translatorHandle != null) {
                this.translatorHandle.close();
                this.translatorHandle = null;
            }
            conversationTranslatorObjects.remove(this);
            this.audioInputKeepAlive = null;
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncRecognitionAction(Runnable recoImplAction) {
        Object object = this.translatorLock;
        synchronized (object) {
            ++this.activeAsyncRecognitionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            recoImplAction.run();
        }
        finally {
            object = this.translatorLock;
            synchronized (object) {
                --this.activeAsyncRecognitionCounter;
            }
        }
    }

    private void initialize() {
        final ConversationTranslator _this = this;
        AsyncThreadService.initialize();
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.sessionStartedSetCallback(_this.translatorHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.sessionStoppedSetCallback(_this.translatorHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.canceledSetCallback(_this.translatorHandle.getValue()));
            }
        });
        this.conversationExpiration.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.conversationExpireSetCallback(_this.translatorHandle.getValue()));
            }
        });
        this.participantsChanged.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.participantsChangedSetCallback(_this.translatorHandle.getValue()));
            }
        });
        this.transcribing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.transcribingSetCallback(_this.translatorHandle.getValue()));
            }
        });
        this.transcribed.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.transcribedSetCallback(_this.translatorHandle.getValue()));
            }
        });
        this.textMessageReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                conversationTranslatorObjects.add(_this);
                Contracts.throwIfFail(ConversationTranslator.this.textMessageSetCallback(_this.translatorHandle.getValue()));
            }
        });
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromHandle(_this.translatorHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private void sessionStartedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            SessionEventArgs arg = new SessionEventArgs(eventArgs, true);
            EventHandlerImpl<SessionEventArgs> handler = this.sessionStarted;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sessionStoppedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            SessionEventArgs arg = new SessionEventArgs(eventArgs, true);
            EventHandlerImpl<SessionEventArgs> handler = this.sessionStopped;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationCanceledEventArgs resultEventArg = new ConversationTranslationCanceledEventArgs(eventArgs, true);
            EventHandlerImpl<ConversationTranslationCanceledEventArgs> handler = this.canceled;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void participantsChangedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationParticipantsChangedEventArgs resultEventArg = new ConversationParticipantsChangedEventArgs(eventArgs, true);
            EventHandlerImpl<ConversationParticipantsChangedEventArgs> handler = this.participantsChanged;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void conversationExpireEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationExpirationEventArgs resultEventArg = new ConversationExpirationEventArgs(eventArgs, true);
            EventHandlerImpl<ConversationExpirationEventArgs> handler = this.conversationExpiration;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void transcribingEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationEventArgs resultEventArg = new ConversationTranslationEventArgs(eventArgs, true);
            EventHandlerImpl<ConversationTranslationEventArgs> handler = this.transcribing;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void transcribedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationEventArgs resultEventArg = new ConversationTranslationEventArgs(eventArgs, true);
            EventHandlerImpl<ConversationTranslationEventArgs> handler = this.transcribed;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void textMessageEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "conversationTranslator");
            if (this.disposed) {
                return;
            }
            ConversationTranslationEventArgs resultEventArg = new ConversationTranslationEventArgs(eventArgs, true);
            EventHandlerImpl<ConversationTranslationEventArgs> handler = this.textMessageReceived;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createConversationTranslatorFromConfig(SafeHandle var1, SafeHandle var2);

    private final native long getPropertyBagFromHandle(SafeHandle var1, IntRef var2);

    private final native long sessionStartedSetCallback(long var1);

    private final native long sessionStoppedSetCallback(long var1);

    private final native long participantsChangedSetCallback(long var1);

    private final native long transcribingSetCallback(long var1);

    private final native long transcribedSetCallback(long var1);

    private final native long textMessageSetCallback(long var1);

    private final native long conversationExpireSetCallback(long var1);

    private final native long canceledSetCallback(long var1);

    private final native long joinConversation(SafeHandle var1, SafeHandle var2, String var3);

    private final native long joinConversationId(SafeHandle var1, String var2, String var3, String var4);

    private final native long leaveConversation(SafeHandle var1);

    private final native long sendText(SafeHandle var1, String var2);

    private final native long startTranscribing(SafeHandle var1);

    private final native long stopTranscribing(SafeHandle var1);

    private final native long setAuthToken(SafeHandle var1, String var2, String var3);
}

