/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.transcription.Participant;
import com.microsoft.cognitiveservices.speech.transcription.User;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class Meeting
implements AutoCloseable {
    private SafeHandle meetingHandle;
    private boolean disposed = false;
    private final Object meetingLock = new Object();
    private int activeAsyncMeetingCounter = 0;
    private PropertyCollection propertyHandle;

    public static Future<Meeting> createMeetingAsync(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        String finalMeetingId = "";
        final SpeechConfig finalSpeechConfig = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Meeting>(){

            @Override
            public Meeting call() {
                IntRef handleRef = new IntRef(0L);
                Contracts.throwIfFail(Meeting.createMeetingFromConfig(handleRef, finalSpeechConfig.getImpl(), ""));
                return new Meeting(handleRef.getValue());
            }
        });
    }

    public static Future<Meeting> createMeetingAsync(SpeechConfig speechConfig, String meetingId) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(meetingId, "meetingId");
        final String finalMeetingId = meetingId;
        final SpeechConfig finalSpeechConfig = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Meeting>(){

            @Override
            public Meeting call() {
                IntRef handleRef = new IntRef(0L);
                Contracts.throwIfFail(Meeting.createMeetingFromConfig(handleRef, finalSpeechConfig.getImpl(), finalMeetingId));
                return new Meeting(handleRef.getValue());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.meetingLock;
        synchronized (object) {
            if (this.activeAsyncMeetingCounter != 0) {
                throw new IllegalStateException("Cannot dispose a recognizer while async recognition is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public String getMeetingId() {
        StringRef meetingIdRef = new StringRef("");
        Contracts.throwIfFail(this.getMeetingId(this.meetingHandle, meetingIdRef));
        return meetingIdRef.getValue();
    }

    public void setAuthorizationToken(String token) {
        Contracts.throwIfNullOrWhitespace(token, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, token);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Participant> addParticipantAsync(Participant participant) {
        final Participant finalParticipant = participant;
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.addParticipant(Meeting.this.meetingHandle, finalParticipant.getImpl()));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return finalParticipant;
            }
        });
    }

    public Future<Participant> addParticipantAsync(final String userId) {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                final Participant[] result = new Participant[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Participant participant = Participant.from(userId);
                        Contracts.throwIfFail(Meeting.this.addParticipant(Meeting.this.meetingHandle, participant.getImpl()));
                        result[0] = participant;
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return result[0];
            }
        });
    }

    public Future<User> addParticipantAsync(final User user) {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<User>(){

            @Override
            public User call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.addParticipantByUser(Meeting.this.meetingHandle, user.getImpl()));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return user;
            }
        });
    }

    public Future<Void> removeParticipantAsync(User user) {
        final User finalUser = user;
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.removeParticipantByUser(Meeting.this.meetingHandle, finalUser.getImpl()));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(Participant participant) {
        final Participant finalParticipant = participant;
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.removeParticipant(Meeting.this.meetingHandle, finalParticipant.getImpl()));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(String userId) {
        final String finalUserId = userId;
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.removeParticipantByUserId(Meeting.this.meetingHandle, finalUserId));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> endMeetingAsync() {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.endMeeting(Meeting.this.meetingHandle));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startMeetingAsync() {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.startMeeting(Meeting.this.meetingHandle));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> deleteMeetingAsync() {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.deleteMeeting(Meeting.this.meetingHandle));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> lockMeetingAsync() {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.lockMeeting(Meeting.this.meetingHandle));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unlockMeetingAsync() {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.unlockMeeting(Meeting.this.meetingHandle));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteAllParticipantsAsync() {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.muteAll(Meeting.this.meetingHandle));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteAllParticipantsAsync() {
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.unmuteAll(Meeting.this.meetingHandle));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteParticipantAsync(String userId) {
        final String finalUserId = userId;
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.muteParticipant(Meeting.this.meetingHandle, finalUserId));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteParticipantAsync(String userId) {
        final String finalUserId = userId;
        final Meeting thisMeeting = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Meeting.this.unmuteParticipant(Meeting.this.meetingHandle, finalUserId));
                    }
                };
                thisMeeting.doAsyncMeetingAction(runnable);
                return null;
            }
        });
    }

    public SafeHandle getImpl() {
        return this.meetingHandle;
    }

    protected void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.meetingHandle != null) {
                this.meetingHandle.close();
                this.meetingHandle = null;
            }
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    protected Meeting(long handleValue) {
        this.meetingHandle = new SafeHandle(handleValue, SafeHandleType.Meeting);
        IntRef propbagRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.meetingHandle, propbagRef));
        this.propertyHandle = new PropertyCollection(propbagRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncMeetingAction(Runnable meetingImplAction) {
        Object object = this.meetingLock;
        synchronized (object) {
            ++this.activeAsyncMeetingCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            meetingImplAction.run();
        }
        finally {
            object = this.meetingLock;
            synchronized (object) {
                --this.activeAsyncMeetingCounter;
            }
        }
    }

    private static final native long createMeetingFromConfig(IntRef var0, SafeHandle var1, String var2);

    private final native long getMeetingId(SafeHandle var1, StringRef var2);

    private final native long addParticipant(SafeHandle var1, SafeHandle var2);

    private final native long addParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipant(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUserId(SafeHandle var1, String var2);

    private final native long startMeeting(SafeHandle var1);

    private final native long endMeeting(SafeHandle var1);

    private final native long deleteMeeting(SafeHandle var1);

    private final native long lockMeeting(SafeHandle var1);

    private final native long unlockMeeting(SafeHandle var1);

    private final native long muteParticipant(SafeHandle var1, String var2);

    private final native long muteAll(SafeHandle var1);

    private final native long unmuteParticipant(SafeHandle var1, String var2);

    private final native long unmuteAll(SafeHandle var1);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);
}

