/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class MeetingTranscriptionResult
extends SpeechRecognitionResult {
    private String userId;
    private String utteranceId;

    protected MeetingTranscriptionResult(long result) {
        super(result);
        if (result != 0L) {
            StringRef userIdStr = new StringRef("");
            Contracts.throwIfFail(this.getUserId(super.getImpl(), userIdStr));
            this.userId = userIdStr.getValue();
            StringRef utteranceIdStr = new StringRef("");
            Contracts.throwIfFail(this.getUtteranceId(super.getImpl(), utteranceIdStr));
            this.utteranceId = utteranceIdStr.getValue();
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUtteranceId() {
        return this.utteranceId;
    }

    @Override
    public String toString() {
        return "ResultId:" + this.getResultId() + " Status:" + (Object)((Object)this.getReason()) + " UserId:" + this.userId + " UtteranceId:" + this.utteranceId + " Recognized text:<" + this.getText() + ">.";
    }

    private final native long getUserId(SafeHandle var1, StringRef var2);

    private final native long getUtteranceId(SafeHandle var1, StringRef var2);
}

