/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public final class User
implements AutoCloseable {
    private SafeHandle userHandle;

    public static User fromUserId(String userId) {
        IntRef userRef = new IntRef(0L);
        Contracts.throwIfFail(User.createFromUserId(userId, userRef));
        return new User(userRef.getValue());
    }

    @Override
    public void close() {
        if (this.userHandle != null) {
            this.userHandle.close();
        }
        this.userHandle = null;
    }

    User(long handle) {
        this.userHandle = new SafeHandle(handle, SafeHandleType.User);
    }

    public String getId() {
        StringRef id = new StringRef("");
        Contracts.throwIfFail(this.getId(this.userHandle, id));
        return id.getValue();
    }

    public SafeHandle getImpl() {
        return this.userHandle;
    }

    private static final native long createFromUserId(String var0, IntRef var1);

    private final native long getId(SafeHandle var1, StringRef var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

