/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.RecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.StringMapRef;
import java.util.HashMap;
import java.util.Map;

public class TranslationRecognitionResult
extends RecognitionResult {
    private Map<String, String> translations;

    public TranslationRecognitionResult(long result) {
        super(result);
        Contracts.throwIfNull(super.getImpl(), "resultHandle");
        StringMapRef translationsRef = new StringMapRef();
        Contracts.throwIfFail(this.getTranslations(super.getImpl(), translationsRef));
        this.translations = new HashMap<String, String>();
        if (!translationsRef.getValue().isEmpty()) {
            this.translations.putAll(translationsRef.getValue());
        }
    }

    public final Map<String, String> getTranslations() {
        return this.translations;
    }

    public String toString() {
        String text = "ResultId:" + this.getResultId() + " Reason:" + (Object)((Object)this.getReason()) + ", Recognized text:<" + this.getText() + ">.\n";
        for (String key : this.translations.keySet()) {
            text = text + "    Translation in " + key + ": <" + this.translations.get(key) + ">.\n";
        }
        return text;
    }

    private final native long getTranslations(SafeHandle var1, StringMapRef var2);
}

