/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AsyncThreadService {
    private static ExecutorService s_executorService;
    private static int s_activeExecutorServiceClientCounter;
    private static Object s_asyncThreadServiceLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = s_asyncThreadServiceLock;
        synchronized (object) {
            if (s_activeExecutorServiceClientCounter == 0) {
                s_executorService = Executors.newCachedThreadPool();
            }
            ++s_activeExecutorServiceClientCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = s_asyncThreadServiceLock;
        synchronized (object) {
            if (--s_activeExecutorServiceClientCounter == 0) {
                s_executorService.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Future<T> submit(Callable<T> task) {
        Object object = s_asyncThreadServiceLock;
        synchronized (object) {
            if (s_executorService.isShutdown() || s_activeExecutorServiceClientCounter == 0) {
                throw new IllegalStateException("ExecutorService has been shutdown", new IllegalStateException());
            }
            return s_executorService.submit(task);
        }
    }

    static {
        s_activeExecutorServiceClientCounter = 0;
        s_asyncThreadServiceLock = new Object();
    }
}

