/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.JsonBuilderJNI;
import com.microsoft.cognitiveservices.speech.util.JsonValueJNI;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class JsonBuilder
implements AutoCloseable {
    public int root;
    private SafeHandle builderHandle;

    public JsonBuilder() {
        JsonBuilder newBuilder = JsonBuilderJNI.createBuilder();
        this.builderHandle = newBuilder.builderHandle;
        this.root = newBuilder.root;
    }

    public JsonBuilder(SafeHandle handle, int root) {
        this.builderHandle = handle;
        this.root = root;
    }

    public int addItem(int item, int index, String find) {
        return JsonBuilderJNI.addItem(this.builderHandle, item, index, find);
    }

    public int setJson(int item, String json) {
        return JsonBuilderJNI.setItem(this.builderHandle, item, json, JsonValueJNI.ValueKind.OBJECT, null, false, 0, 0.0);
    }

    public int setString(int item, String str) {
        return JsonBuilderJNI.setItem(this.builderHandle, item, null, JsonValueJNI.ValueKind.STRING, str, false, 0, 0.0);
    }

    public int setBoolean(int item, boolean value) {
        return JsonBuilderJNI.setItem(this.builderHandle, item, null, JsonValueJNI.ValueKind.BOOLEAN, null, value, 0, 0.0);
    }

    public int setInteger(int item, int integer) {
        return JsonBuilderJNI.setItem(this.builderHandle, item, null, JsonValueJNI.ValueKind.NUMBER, null, false, integer, 0.0);
    }

    public int setDouble(int item, double value) {
        return JsonBuilderJNI.setItem(this.builderHandle, item, null, JsonValueJNI.ValueKind.NUMBER, null, false, 0, value);
    }

    public String toString() {
        return JsonBuilderJNI.asJsonCopy(this.builderHandle, this.root);
    }

    @Override
    public void close() throws Exception {
        if (this.builderHandle != null) {
            this.builderHandle.close();
            this.builderHandle = null;
        }
    }
}

