/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.JsonBuilder;
import com.microsoft.cognitiveservices.speech.util.JsonValueJNI;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class JsonBuilderJNI {
    private static long INVALID_ARG = 5L;

    public static JsonBuilder createBuilder() {
        IntRef handle = new IntRef(0L);
        int root = JsonBuilderJNI.createJsonBuilderHandle(handle);
        SafeHandle builderHandle = new SafeHandle(handle.getValue(), SafeHandleType.JSONBUILDER);
        return new JsonBuilder(builderHandle, root);
    }

    public static int addItem(SafeHandle builderHandle, int item, int index, String find) {
        return JsonBuilderJNI.builderAdd(builderHandle, item, index, find);
    }

    public static int setItem(SafeHandle builderHandle, int item, String json, JsonValueJNI.ValueKind kind, String str, boolean boolValue, int integer, double number) {
        return JsonBuilderJNI.builderSet(builderHandle, item, json, kind.getValue(), str, boolValue, integer, number);
    }

    public static String asJsonCopy(SafeHandle builder, int item) {
        return JsonBuilderJNI.builderAsJsonCopy(builder, item);
    }

    private static final native String builderAsJsonCopy(SafeHandle var0, int var1);

    private static final native int createJsonBuilderHandle(IntRef var0);

    private static final native int builderAdd(SafeHandle var0, int var1, int var2, String var3);

    private static final native int builderSet(SafeHandle var0, int var1, String var2, int var3, String var4, boolean var5, int var6, double var7);
}

