/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.JsonValueJNI;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class JsonValue
implements AutoCloseable {
    private int item;
    private SafeHandle parserHandle;

    public JsonValue(int item, SafeHandle handle) {
        this.item = item;
        this.parserHandle = handle;
    }

    public static JsonValue Parse(String json) {
        return JsonValueJNI.createParser(json);
    }

    public String asString() {
        return JsonValueJNI.asString(this.parserHandle, this.item);
    }

    public long asInt() {
        return JsonValueJNI.asInt(this.parserHandle, this.item);
    }

    public float asFloat() {
        return JsonValueJNI.asFloat(this.parserHandle, this.item);
    }

    public boolean asBoolean() {
        return JsonValueJNI.asBoolean(this.parserHandle, this.item);
    }

    public String asJson() {
        return JsonValueJNI.asJson(this.parserHandle, this.item);
    }

    public JsonValue get(String key) {
        return JsonValueJNI.getValue(this.parserHandle, this.item, 0, key);
    }

    public JsonValue get(int index) {
        return JsonValueJNI.getValue(this.parserHandle, this.item, index, null);
    }

    public String getName(int index) {
        return JsonValueJNI.getName(this.parserHandle, this.item, index, null);
    }

    public boolean hasValue(int index) {
        return JsonValueJNI.hasValue(this.parserHandle, this.item, index, null);
    }

    public boolean hasValue(String key) {
        return JsonValueJNI.hasValue(this.parserHandle, this.item, 0, key);
    }

    public int count() {
        return JsonValueJNI.count(this.parserHandle, this.item);
    }

    @Override
    public void close() throws Exception {
        if (this.parserHandle != null) {
            this.parserHandle.close();
            this.parserHandle = null;
        }
    }
}

