/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.JsonValue;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class JsonValueJNI {
    private static long INVALID_ARG = 5L;

    public static JsonValue createParser(String json) {
        IntRef handle = new IntRef(0L);
        int item = JsonValueJNI.createJsonParserHandle(json, handle);
        SafeHandle parserHandle = new SafeHandle(handle.getValue(), SafeHandleType.JSONVALUE);
        return new JsonValue(item, parserHandle);
    }

    public static String asString(SafeHandle parserHandle, int item) {
        if (JsonValueJNI.kind(parserHandle, item) != ValueKind.STRING.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return JsonValueJNI.asString(parserHandle, item, null);
    }

    public static long asInt(SafeHandle parserHandle, int item) {
        if (JsonValueJNI.kind(parserHandle, item) != ValueKind.NUMBER.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return JsonValueJNI.asInt(parserHandle, item, 0L);
    }

    public static float asFloat(SafeHandle parserHandle, int item) {
        if (JsonValueJNI.kind(parserHandle, item) != ValueKind.NUMBER.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return (float)JsonValueJNI.asDouble(parserHandle, item, 0.0);
    }

    public static boolean asBoolean(SafeHandle parserHandle, int item) {
        if (JsonValueJNI.kind(parserHandle, item) != ValueKind.BOOLEAN.getValue()) {
            Contracts.throwIfFail(INVALID_ARG);
        }
        return JsonValueJNI.asBoolean(parserHandle, item, false);
    }

    public static JsonValue getValue(SafeHandle parserHandle, int item, int index, String key) {
        int newItem = JsonValueJNI.get(parserHandle, item, index, key);
        return new JsonValue(newItem, parserHandle);
    }

    public static String getName(SafeHandle parserHandle, int item, int index, String key) {
        String result = JsonValueJNI.getName(parserHandle, item, index);
        return result;
    }

    public static boolean hasValue(SafeHandle parserHandle, int item, int index, String key) {
        return JsonValueJNI.get(parserHandle, item, index, key) > 0;
    }

    public static final native int count(SafeHandle var0, int var1);

    public static final native String asJson(SafeHandle var0, int var1);

    private static final native int createJsonParserHandle(String var0, IntRef var1);

    private static final native long asInt(SafeHandle var0, int var1, long var2);

    private static final native String asString(SafeHandle var0, int var1, String var2);

    private static final native double asDouble(SafeHandle var0, int var1, double var2);

    private static final native boolean asBoolean(SafeHandle var0, int var1, boolean var2);

    private static final native int kind(SafeHandle var0, int var1);

    private static final native int get(SafeHandle var0, int var1, int var2, String var3);

    private static final native String getName(SafeHandle var0, int var1, int var2);

    static enum ValueKind {
        ERROR(-1),
        END(0),
        OBJECT(123),
        ARRAY(91),
        STRING(34),
        NUMBER(49),
        BOOLEAN(98),
        NULL(110),
        UNSPECIFIED(63);

        private int id;

        private ValueKind(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }
}

