/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.ICoreAuthenticationProvider;
import com.microsoft.graph.httpcore.middlewareoption.MiddlewareType;
import com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthenticationHandler
implements Interceptor {
    public final MiddlewareType MIDDLEWARE_TYPE = MiddlewareType.AUTHENTICATION;
    private ICoreAuthenticationProvider authProvider;

    public AuthenticationHandler(ICoreAuthenticationProvider authProvider) {
        this.authProvider = authProvider;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (originalRequest.tag(TelemetryOptions.class) == null) {
            originalRequest = originalRequest.newBuilder().tag(TelemetryOptions.class, (Object)new TelemetryOptions()).build();
        }
        ((TelemetryOptions)originalRequest.tag(TelemetryOptions.class)).setFeatureUsage(4);
        Request authenticatedRequest = this.authProvider.authenticateRequest(originalRequest);
        return chain.proceed(authenticatedRequest);
    }
}

