/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.authentication;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.microsoft.graph.authentication.BaseAuthenticationProvider;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class TokenCredentialAuthProvider
extends BaseAuthenticationProvider {
    private final TokenCredential tokenCredential;
    private final TokenRequestContext context;
    private static final String DEFAULT_GRAPH_SCOPE = "https://graph.microsoft.com/.default";

    public TokenCredentialAuthProvider(@Nonnull TokenCredential tokenCredential) {
        this(Arrays.asList(DEFAULT_GRAPH_SCOPE), tokenCredential);
    }

    public TokenCredentialAuthProvider(@Nonnull List<String> scopes, @Nonnull TokenCredential tokenCredential) {
        if (scopes == null || scopes.isEmpty()) {
            throw new IllegalArgumentException("scopes parameter cannot be null or empty");
        }
        this.context = new TokenRequestContext();
        this.context.setScopes(scopes);
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "tokenCredential parameter cannot be null.");
    }

    @Override
    @Nonnull
    public CompletableFuture<String> getAuthorizationTokenAsync(@Nonnull URL requestUrl) {
        if (this.shouldAuthenticateRequestWithUrl(Objects.requireNonNull(requestUrl, "requestUrl parameter cannot be null"))) {
            return this.tokenCredential.getToken(this.context).toFuture().thenApply(resp -> resp.getToken());
        }
        return CompletableFuture.completedFuture(null);
    }
}

