/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.httpcore.middlewareoption.MiddlewareType;
import com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthenticationHandler
implements Interceptor {
    protected static final String BEARER = "Bearer ";
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    public final MiddlewareType MIDDLEWARE_TYPE = MiddlewareType.AUTHENTICATION;
    private IAuthenticationProvider authProvider;

    public AuthenticationHandler(@Nonnull IAuthenticationProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        TelemetryOptions telemetryOptions = (TelemetryOptions)originalRequest.tag(TelemetryOptions.class);
        if (telemetryOptions == null) {
            telemetryOptions = new TelemetryOptions();
            originalRequest = originalRequest.newBuilder().tag(TelemetryOptions.class, (Object)telemetryOptions).build();
        }
        telemetryOptions.setFeatureUsage(4);
        try {
            CompletableFuture<String> future = this.authProvider.getAuthorizationTokenAsync(originalRequest.url().url());
            String accessToken = future.get();
            if (accessToken == null) {
                return chain.proceed(originalRequest);
            }
            return chain.proceed(originalRequest.newBuilder().addHeader(AUTHORIZATION_HEADER, BEARER + accessToken).build());
        }
        catch (InterruptedException | ExecutionException ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException(ex);
        }
    }
}

