/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.models;

import com.microsoft.graph.core.models.IUploadSession;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UploadSession
implements IUploadSession {
    private String uploadUrl = "";
    private List<String> nextExpectedRanges;
    private OffsetDateTime expirationDateTime;
    private Map<String, Object> additionalData = new HashMap<String, Object>();
    private static final String UPLOAD_URL = "uploadUrl";
    private static final String NEXT_EXPECTED_RANGES = "nextExpectedRanges";
    private static final String EXPIRATION_DATE_TIME = "expirationDateTime";

    @Nullable
    public UploadSession() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Override
    @Nonnull
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    public void setUploadUrl(@Nonnull String uploadUrl) {
        if (Compatibility.isBlank((String)uploadUrl)) {
            throw new IllegalArgumentException("uploadUrl cannot be null or empty");
        }
        this.uploadUrl = uploadUrl;
    }

    @Override
    @Nullable
    public List<String> getNextExpectedRanges() {
        if (this.nextExpectedRanges == null) {
            return null;
        }
        return new ArrayList<String>(this.nextExpectedRanges);
    }

    @Override
    public void setNextExpectedRanges(@Nonnull List<String> nextExpectedRanges) {
        Objects.requireNonNull(nextExpectedRanges, "The following parameter cannot be null: nextExpectedRanges");
        this.nextExpectedRanges = new ArrayList<String>(nextExpectedRanges);
    }

    @Override
    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    @Override
    public void setExpirationDateTime(@Nullable OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        return new HashMap<String, Object>(this.additionalData);
    }

    public void setAdditionalData(@Nonnull Map<String, Object> additionalData) {
        Objects.requireNonNull(additionalData, "The following parameter cannot be null: additionalData");
        this.additionalData = new HashMap<String, Object>(additionalData);
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        UploadSession currentObj = this;
        HashMap<String, Consumer<ParseNode>> deserializers = new HashMap<String, Consumer<ParseNode>>(3);
        deserializers.put(EXPIRATION_DATE_TIME, n -> currentObj.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializers.put(NEXT_EXPECTED_RANGES, n -> currentObj.setNextExpectedRanges(n.getCollectionOfPrimitiveValues(String.class)));
        deserializers.put(UPLOAD_URL, n -> currentObj.setUploadUrl(n.getStringValue()));
        return deserializers;
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer, "The following parameter cannot be null: writer");
        writer.writeOffsetDateTimeValue(EXPIRATION_DATE_TIME, this.getExpirationDateTime());
        writer.writeCollectionOfPrimitiveValues(NEXT_EXPECTED_RANGES, this.getNextExpectedRanges());
        writer.writeStringValue(UPLOAD_URL, this.getUploadUrl());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    @Nonnull
    public static UploadSession createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UploadSession();
    }
}

