/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests.upload;

import com.microsoft.graph.core.models.UploadResult;
import com.microsoft.graph.core.requests.upload.UploadResponseHandler;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.NativeResponseHandler;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import okhttp3.Response;

public class UploadSliceRequestBuilder<T extends Parsable> {
    private final UploadResponseHandler responseHandler;
    private final RequestAdapter requestAdapter;
    private final String urlTemplate;
    private final long rangeBegin;
    private final long rangeEnd;
    private final long totalSessionLength;
    private final long rangeLength;
    private final ParsableFactory<T> factory;

    public UploadSliceRequestBuilder(@Nonnull String sessionUrl, @Nonnull RequestAdapter requestAdapter, long rangeBegin, long rangeEnd, long totalSessionLength, @Nonnull ParsableFactory<T> factory) {
        if (Compatibility.isBlank((String)sessionUrl)) {
            throw new IllegalArgumentException("sessionUrl cannot be null or empty");
        }
        this.urlTemplate = sessionUrl;
        this.requestAdapter = Objects.requireNonNull(requestAdapter);
        this.factory = factory;
        this.rangeBegin = rangeBegin;
        this.rangeEnd = rangeEnd;
        this.rangeLength = rangeEnd - rangeBegin + 1L;
        this.totalSessionLength = totalSessionLength;
        this.responseHandler = new UploadResponseHandler();
    }

    @Nonnull
    public UploadResult<T> put(@Nonnull InputStream stream) {
        Objects.requireNonNull(stream);
        RequestInformation requestInformation = this.toPutRequestInformation(stream);
        NativeResponseHandler nativeResponseHandler = new NativeResponseHandler();
        requestInformation.setResponseHandler((ResponseHandler)nativeResponseHandler);
        this.requestAdapter.sendPrimitive(requestInformation, null, InputStream.class);
        return this.responseHandler.handleResponse((Response)nativeResponseHandler.getValue(), this.factory);
    }

    private RequestInformation toPutRequestInformation(InputStream stream) {
        Objects.requireNonNull(stream);
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.PUT;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.setStreamContent(stream, "application/octet-stream");
        requestInfo.headers.add("Content-Range", String.format(Locale.US, "bytes %d-%d/%d", this.rangeBegin, this.rangeEnd, this.totalSessionLength));
        requestInfo.headers.add("Content-Length", "" + this.rangeLength);
        return requestInfo;
    }

    public long getRangeLength() {
        return this.rangeLength;
    }

    public long getRangeBegin() {
        return this.rangeBegin;
    }

    public long getRangeEnd() {
        return this.rangeEnd;
    }

    public long getTotalSessionLength() {
        return this.totalSessionLength;
    }
}

