/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.models;

import com.microsoft.graph.core.models.DecryptableContent;
import com.microsoft.graph.core.models.DiscoverUrlAdapter;
import com.microsoft.graph.core.models.EncryptedContentBearer;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public interface TokenValidable<U extends DecryptableContent, T extends EncryptedContentBearer<U>> {
    public static final String graphNotificationPublisher = "0bf30f3b-4a52-48df-9a82-234910c4a086";

    public void setValidationTokens(@Nullable List<String> var1);

    @Nullable
    public List<String> getValidationTokens();

    public void setValue(@Nullable List<T> var1);

    @Nullable
    public List<T> getValue();

    public static <U extends DecryptableContent, T extends EncryptedContentBearer<U>> boolean areTokensValid(@Nonnull TokenValidable<U, T> collection, @Nonnull List<UUID> tenantIds, @Nonnull List<UUID> appIds, @Nonnull String keyDiscoveryUrl) {
        Objects.requireNonNull(collection);
        Objects.requireNonNull(tenantIds);
        Objects.requireNonNull(appIds);
        Objects.requireNonNull(keyDiscoveryUrl);
        if (collection.getValidationTokens() == null || collection.getValidationTokens().isEmpty() || collection.getValue().stream().allMatch(x -> x.getEncryptedContent() == null)) {
            return true;
        }
        if (tenantIds.isEmpty() || appIds.isEmpty()) {
            throw new IllegalArgumentException("tenantIds, appIds and issuer formats must be provided");
        }
        for (String token : collection.getValidationTokens()) {
            if (TokenValidable.isTokenValid(token, tenantIds, appIds, keyDiscoveryUrl)) continue;
            return false;
        }
        return true;
    }

    public static <U extends DecryptableContent, T extends EncryptedContentBearer<U>> boolean areTokensValid(@Nonnull TokenValidable<U, T> collection, @Nonnull List<UUID> tenantIds, @Nonnull List<UUID> appIds) {
        String keyDiscoveryUrl = "https://login.microsoftonline.com/common/discovery/keys";
        return TokenValidable.areTokensValid(collection, tenantIds, appIds, "https://login.microsoftonline.com/common/discovery/keys");
    }

    public static <U extends DecryptableContent, T extends EncryptedContentBearer<U>> boolean isTokenValid(@Nonnull String token, @Nonnull List<UUID> tenantIds, @Nonnull List<UUID> appIds, @Nonnull String keyDiscoveryUrl) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(tenantIds);
        Objects.requireNonNull(appIds);
        Objects.requireNonNull(keyDiscoveryUrl);
        if (tenantIds.isEmpty() || appIds.isEmpty()) {
            throw new IllegalArgumentException("tenantIds, appIds and issuer formats must be provided");
        }
        try {
            DiscoverUrlAdapter discoverUrlAdapter = new DiscoverUrlAdapter(keyDiscoveryUrl);
            Jws parsedToken = Jwts.parser().keyLocator((Locator)discoverUrlAdapter).build().parseSignedClaims((CharSequence)token);
            Claims body = (Claims)parsedToken.getPayload();
            if (body.getExpiration().before(new Date())) {
                throw new IllegalArgumentException("Token is expired");
            }
            String issuer = body.getIssuer();
            Set audience = body.getAudience();
            boolean isAudienceValid = false;
            for (UUID appId : appIds) {
                if (!audience.contains(appId.toString())) continue;
                isAudienceValid = true;
                break;
            }
            boolean isIssuerValid = false;
            for (UUID tenantId : tenantIds) {
                if (!issuer.contains(tenantId.toString())) continue;
                isIssuerValid = true;
                break;
            }
            if (!((String)body.get("azp", String.class)).equals(graphNotificationPublisher)) {
                throw new IllegalArgumentException("Invalid token publisher. Expected Graph notification publisher (azp): 0bf30f3b-4a52-48df-9a82-234910c4a086");
            }
            return isAudienceValid && isIssuerValid;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid token", e);
        }
    }
}

