/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.extensions.DriveItemUploadableProperties;
import com.microsoft.graph.models.extensions.DriveRecipient;
import com.microsoft.graph.models.extensions.ItemReference;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemCopyRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemCreateLinkRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemCreateUploadSessionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemInviteCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemPreviewRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemRequest;
import com.microsoft.graph.requests.extensions.DriveItemSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemStreamRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemVersionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemCopyRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemCreateLinkRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemCreateUploadSessionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemInviteCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemPreviewRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemRequest;
import com.microsoft.graph.requests.extensions.IDriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemStreamRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemVersionRequestBuilder;
import com.microsoft.graph.requests.extensions.IListItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IPermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPermissionRequestBuilder;
import com.microsoft.graph.requests.extensions.IThumbnailSetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IThumbnailSetRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookRequestBuilder;
import com.microsoft.graph.requests.extensions.ListItemRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PermissionRequestBuilder;
import com.microsoft.graph.requests.extensions.ThumbnailSetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ThumbnailSetRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookRequestBuilder;
import java.util.List;

public class DriveItemRequestBuilder
extends BaseRequestBuilder
implements IDriveItemRequestBuilder {
    public DriveItemRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Override
    public IDriveItemRequest buildRequest() {
        return this.buildRequest(this.getOptions());
    }

    @Override
    public IDriveItemRequest buildRequest(List<? extends Option> requestOptions) {
        return new DriveItemRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Override
    public IDriveItemRequestBuilder itemWithPath(String path) {
        return new DriveItemRequestBuilder(this.getRequestUrl() + ":/" + path + ":", this.getClient(), null);
    }

    @Override
    public IDriveItemCollectionRequestBuilder children() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("children"), this.getClient(), null);
    }

    @Override
    public IDriveItemRequestBuilder children(String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("children") + "/" + id, this.getClient(), null);
    }

    @Override
    public IListItemRequestBuilder listItem() {
        return new ListItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("listItem"), this.getClient(), null);
    }

    @Override
    public IPermissionCollectionRequestBuilder permissions() {
        return new PermissionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("permissions"), this.getClient(), null);
    }

    @Override
    public IPermissionRequestBuilder permissions(String id) {
        return new PermissionRequestBuilder(this.getRequestUrlWithAdditionalSegment("permissions") + "/" + id, this.getClient(), null);
    }

    @Override
    public IThumbnailSetCollectionRequestBuilder thumbnails() {
        return new ThumbnailSetCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("thumbnails"), this.getClient(), null);
    }

    @Override
    public IThumbnailSetRequestBuilder thumbnails(String id) {
        return new ThumbnailSetRequestBuilder(this.getRequestUrlWithAdditionalSegment("thumbnails") + "/" + id, this.getClient(), null);
    }

    @Override
    public IDriveItemVersionCollectionRequestBuilder versions() {
        return new DriveItemVersionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("versions"), this.getClient(), null);
    }

    @Override
    public IDriveItemVersionRequestBuilder versions(String id) {
        return new DriveItemVersionRequestBuilder(this.getRequestUrlWithAdditionalSegment("versions") + "/" + id, this.getClient(), null);
    }

    @Override
    public IWorkbookRequestBuilder workbook() {
        return new WorkbookRequestBuilder(this.getRequestUrlWithAdditionalSegment("workbook"), this.getClient(), null);
    }

    @Override
    public IDriveItemStreamRequestBuilder content() {
        return new DriveItemStreamRequestBuilder(this.getRequestUrlWithAdditionalSegment("content"), this.getClient(), null);
    }

    @Override
    public IDriveItemCopyRequestBuilder copy(String name, ItemReference parentReference) {
        return new DriveItemCopyRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.copy"), this.getClient(), null, name, parentReference);
    }

    @Override
    public IDriveItemCreateLinkRequestBuilder createLink(String type, String scope) {
        return new DriveItemCreateLinkRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.createLink"), this.getClient(), null, type, scope);
    }

    @Override
    public IDriveItemCreateUploadSessionRequestBuilder createUploadSession(DriveItemUploadableProperties item) {
        return new DriveItemCreateUploadSessionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.createUploadSession"), this.getClient(), null, item);
    }

    @Override
    public IDriveItemInviteCollectionRequestBuilder invite(Boolean requireSignIn, List<String> roles, Boolean sendInvitation, String message, List<DriveRecipient> recipients) {
        return new DriveItemInviteCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.invite"), this.getClient(), null, requireSignIn, roles, sendInvitation, message, recipients);
    }

    @Override
    public IDriveItemPreviewRequestBuilder preview(String page, Double zoom) {
        return new DriveItemPreviewRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.preview"), this.getClient(), null, page, zoom);
    }

    @Override
    public IDriveItemDeltaCollectionRequestBuilder delta(String token) {
        return new DriveItemDeltaCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), this.getClient(), null, token);
    }

    @Override
    public IDriveItemDeltaCollectionRequestBuilder delta() {
        return new DriveItemDeltaCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), this.getClient(), null);
    }

    @Override
    public IDriveItemSearchCollectionRequestBuilder search(String q) {
        return new DriveItemSearchCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.search"), this.getClient(), null, q);
    }
}

