/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserReminderViewCollectionPage;
import com.microsoft.graph.requests.extensions.IUserReminderViewCollectionRequest;
import com.microsoft.graph.requests.extensions.UserReminderViewCollectionPage;
import com.microsoft.graph.requests.extensions.UserReminderViewCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UserReminderViewCollectionResponse;
import java.util.List;

public class UserReminderViewCollectionRequest
extends BaseCollectionRequest<UserReminderViewCollectionResponse, IUserReminderViewCollectionPage>
implements IUserReminderViewCollectionRequest {
    public UserReminderViewCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserReminderViewCollectionResponse.class, IUserReminderViewCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUserReminderViewCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UserReminderViewCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserReminderViewCollectionPage get() throws ClientException {
        UserReminderViewCollectionResponse response = (UserReminderViewCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IUserReminderViewCollectionPage buildFromResponse(UserReminderViewCollectionResponse response) {
        UserReminderViewCollectionRequestBuilder builder = response.nextLink != null ? new UserReminderViewCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null) : null;
        UserReminderViewCollectionPage page = new UserReminderViewCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IUserReminderViewCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserReminderViewCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IUserReminderViewCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

