// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.MeetingParticipants;
import com.microsoft.graph.models.extensions.AudioConferencing;
import com.microsoft.graph.models.extensions.ChatInfo;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Online Meeting.
 */
public class OnlineMeeting extends Entity implements IJsonBackedObject {


    /**
     * The Creation Date Time.
     * 
     */
    @SerializedName("creationDateTime")
    @Expose
    public java.util.Calendar creationDateTime;

    /**
     * The Start Date Time.
     * 
     */
    @SerializedName("startDateTime")
    @Expose
    public java.util.Calendar startDateTime;

    /**
     * The End Date Time.
     * 
     */
    @SerializedName("endDateTime")
    @Expose
    public java.util.Calendar endDateTime;

    /**
     * The Join Url.
     * 
     */
    @SerializedName("joinUrl")
    @Expose
    public String joinUrl;

    /**
     * The Subject.
     * 
     */
    @SerializedName("subject")
    @Expose
    public String subject;

    /**
     * The Participants.
     * 
     */
    @SerializedName("participants")
    @Expose
    public MeetingParticipants participants;

    /**
     * The Audio Conferencing.
     * 
     */
    @SerializedName("audioConferencing")
    @Expose
    public AudioConferencing audioConferencing;

    /**
     * The Chat Info.
     * 
     */
    @SerializedName("chatInfo")
    @Expose
    public ChatInfo chatInfo;

    /**
     * The Video Teleconference Id.
     * 
     */
    @SerializedName("videoTeleconferenceId")
    @Expose
    public String videoTeleconferenceId;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
