// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ICalendarRequest;
import com.microsoft.graph.requests.extensions.CalendarRequest;
import com.microsoft.graph.models.extensions.Calendar;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Request.
 */
public class CalendarRequest extends BaseRequest implements ICalendarRequest {
	
    /**
     * The request for the Calendar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CalendarRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Calendar.class);
    }

    /**
     * Gets the Calendar from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<Calendar> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Calendar from the service
     *
     * @return the Calendar from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Calendar get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<Calendar> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Calendar with a source
     *
     * @param sourceCalendar the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Calendar sourceCalendar, final ICallback<Calendar> callback) {
        send(HttpMethod.PATCH, callback, sourceCalendar);
    }

    /**
     * Patches this Calendar with a source
     *
     * @param sourceCalendar the source object with updates
     * @return the updated Calendar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Calendar patch(final Calendar sourceCalendar) throws ClientException {
        return send(HttpMethod.PATCH, sourceCalendar);
    }

    /**
     * Creates a Calendar with a new object
     *
     * @param newCalendar the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Calendar newCalendar, final ICallback<Calendar> callback) {
        send(HttpMethod.POST, callback, newCalendar);
    }

    /**
     * Creates a Calendar with a new object
     *
     * @param newCalendar the new object to create
     * @return the created Calendar
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Calendar post(final Calendar newCalendar) throws ClientException {
        return send(HttpMethod.POST, newCalendar);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ICalendarRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (CalendarRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ICalendarRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (CalendarRequest)this;
     }

}

