// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Contact Folder Collection Request Builder.
 */
public class ContactFolderCollectionRequestBuilder extends BaseRequestBuilder implements IContactFolderCollectionRequestBuilder {

    /**
     * The request builder for this collection of ContactFolder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContactFolderCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IContactFolderCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IContactFolderCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ContactFolderCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IContactFolderRequestBuilder byId(final String id) {
        return new ContactFolderRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }



    public IContactFolderDeltaCollectionRequestBuilder delta() {
        return new ContactFolderDeltaCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), getClient(), null);
    }

	public IContactFolderDeltaCollectionRequestBuilder delta(final String deltaLink) {
        return new ContactFolderDeltaCollectionRequestBuilder(deltaLink, getClient(), null);
    }
}
