// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ICloudCommunicationsRequest;
import com.microsoft.graph.requests.extensions.ICallCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ICallRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnlineMeetingCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnlineMeetingRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Cloud Communications Request Builder.
 */
public interface ICloudCommunicationsRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the ICloudCommunicationsRequest instance
     */
    ICloudCommunicationsRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the ICloudCommunicationsRequest instance
     */
    ICloudCommunicationsRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    ICallCollectionRequestBuilder calls();

    ICallRequestBuilder calls(final String id);

    IOnlineMeetingCollectionRequestBuilder onlineMeetings();

    IOnlineMeetingRequestBuilder onlineMeetings(final String id);

}
