// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DirectoryRole;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Directory Role Request.
 */
public interface IDirectoryRoleRequest extends IHttpRequest {

    /**
     * Gets the DirectoryRole from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<DirectoryRole> callback);

    /**
     * Gets the DirectoryRole from the service
     *
     * @return the DirectoryRole from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryRole get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<DirectoryRole> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DirectoryRole with a source
     *
     * @param sourceDirectoryRole the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DirectoryRole sourceDirectoryRole, final ICallback<DirectoryRole> callback);

    /**
     * Patches this DirectoryRole with a source
     *
     * @param sourceDirectoryRole the source object with updates
     * @return the updated DirectoryRole
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryRole patch(final DirectoryRole sourceDirectoryRole) throws ClientException;

    /**
     * Posts a DirectoryRole with a new object
     *
     * @param newDirectoryRole the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DirectoryRole newDirectoryRole, final ICallback<DirectoryRole> callback);

    /**
     * Posts a DirectoryRole with a new object
     *
     * @param newDirectoryRole the new object to create
     * @return the created DirectoryRole
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryRole post(final DirectoryRole newDirectoryRole) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDirectoryRoleRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDirectoryRoleRequest expand(final String value);

}

