// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.IosManagedAppRegistration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Ios Managed App Registration Request.
 */
public interface IIosManagedAppRegistrationRequest extends IHttpRequest {

    /**
     * Gets the IosManagedAppRegistration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<IosManagedAppRegistration> callback);

    /**
     * Gets the IosManagedAppRegistration from the service
     *
     * @return the IosManagedAppRegistration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosManagedAppRegistration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<IosManagedAppRegistration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this IosManagedAppRegistration with a source
     *
     * @param sourceIosManagedAppRegistration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final IosManagedAppRegistration sourceIosManagedAppRegistration, final ICallback<IosManagedAppRegistration> callback);

    /**
     * Patches this IosManagedAppRegistration with a source
     *
     * @param sourceIosManagedAppRegistration the source object with updates
     * @return the updated IosManagedAppRegistration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosManagedAppRegistration patch(final IosManagedAppRegistration sourceIosManagedAppRegistration) throws ClientException;

    /**
     * Posts a IosManagedAppRegistration with a new object
     *
     * @param newIosManagedAppRegistration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final IosManagedAppRegistration newIosManagedAppRegistration, final ICallback<IosManagedAppRegistration> callback);

    /**
     * Posts a IosManagedAppRegistration with a new object
     *
     * @param newIosManagedAppRegistration the new object to create
     * @return the created IosManagedAppRegistration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosManagedAppRegistration post(final IosManagedAppRegistration newIosManagedAppRegistration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IIosManagedAppRegistrationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IIosManagedAppRegistrationRequest expand(final String value);

}

