// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Item Analytics With Reference Request.
 */
public interface IItemAnalyticsWithReferenceRequest extends IHttpRequest {

    void post(final ItemAnalytics newItemAnalytics, final IJsonBackedObject payload, final ICallback<ItemAnalytics> callback);

    ItemAnalytics post(final ItemAnalytics newItemAnalytics, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<ItemAnalytics> callback);

    ItemAnalytics get() throws ClientException;

	void delete(final ICallback<ItemAnalytics> callback);

	void delete() throws ClientException;

	void patch(final ItemAnalytics sourceItemAnalytics, final ICallback<ItemAnalytics> callback);

	ItemAnalytics patch(final ItemAnalytics sourceItemAnalytics) throws ClientException;

    IItemAnalyticsWithReferenceRequest select(final String value);

    IItemAnalyticsWithReferenceRequest expand(final String value);

}
