// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.INotificationMessageTemplateRequest;
import com.microsoft.graph.requests.extensions.ILocalizedNotificationMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ILocalizedNotificationMessageRequestBuilder;
import com.microsoft.graph.requests.extensions.INotificationMessageTemplateSendTestMessageRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Notification Message Template Request Builder.
 */
public interface INotificationMessageTemplateRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the INotificationMessageTemplateRequest instance
     */
    INotificationMessageTemplateRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the INotificationMessageTemplateRequest instance
     */
    INotificationMessageTemplateRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    ILocalizedNotificationMessageCollectionRequestBuilder localizedNotificationMessages();

    ILocalizedNotificationMessageRequestBuilder localizedNotificationMessages(final String id);
    INotificationMessageTemplateSendTestMessageRequestBuilder sendTestMessage();

}
