// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IPlannerTaskRequest;
import com.microsoft.graph.requests.extensions.IPlannerTaskDetailsRequestBuilder;
import com.microsoft.graph.requests.extensions.IPlannerAssignedToTaskBoardTaskFormatRequestBuilder;
import com.microsoft.graph.requests.extensions.IPlannerProgressTaskBoardTaskFormatRequestBuilder;
import com.microsoft.graph.requests.extensions.IPlannerBucketTaskBoardTaskFormatRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Planner Task Request Builder.
 */
public interface IPlannerTaskRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IPlannerTaskRequest instance
     */
    IPlannerTaskRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IPlannerTaskRequest instance
     */
    IPlannerTaskRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    /**
     * Gets the request builder for PlannerTaskDetails
     *
     * @return the IPlannerTaskDetailsRequestBuilder instance
     */
    IPlannerTaskDetailsRequestBuilder details();

    /**
     * Gets the request builder for PlannerAssignedToTaskBoardTaskFormat
     *
     * @return the IPlannerAssignedToTaskBoardTaskFormatRequestBuilder instance
     */
    IPlannerAssignedToTaskBoardTaskFormatRequestBuilder assignedToTaskBoardFormat();

    /**
     * Gets the request builder for PlannerProgressTaskBoardTaskFormat
     *
     * @return the IPlannerProgressTaskBoardTaskFormatRequestBuilder instance
     */
    IPlannerProgressTaskBoardTaskFormatRequestBuilder progressTaskBoardFormat();

    /**
     * Gets the request builder for PlannerBucketTaskBoardTaskFormat
     *
     * @return the IPlannerBucketTaskBoardTaskFormatRequestBuilder instance
     */
    IPlannerBucketTaskBoardTaskFormatRequestBuilder bucketTaskBoardFormat();

}
