// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Terms And Conditions Reference Request.
 */
public interface ITermsAndConditionsReferenceRequest extends IHttpRequest {

    void delete(final ICallback<TermsAndConditions> callback);

    TermsAndConditions delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITermsAndConditionsReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITermsAndConditionsReferenceRequest expand(final String value);

    /**
     * Puts the TermsAndConditions
     *
     * @param srcTermsAndConditions the TermsAndConditions to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(TermsAndConditions srcTermsAndConditions, final ICallback<TermsAndConditions> callback);

    /**
     * Puts the TermsAndConditions
     *
     * @param srcTermsAndConditions the TermsAndConditions to PUT
     * @return the TermsAndConditions
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    TermsAndConditions put(TermsAndConditions srcTermsAndConditions) throws ClientException;
}
