// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MessageCreateReplyAllBody;
import com.microsoft.graph.models.extensions.Message;
import com.microsoft.graph.requests.extensions.IMessageCreateReplyAllRequest;
import com.microsoft.graph.requests.extensions.MessageCreateReplyAllRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Create Reply All Request.
 */
public class MessageCreateReplyAllRequest extends BaseRequest implements IMessageCreateReplyAllRequest {
    protected final MessageCreateReplyAllBody body;

    /**
     * The request for this MessageCreateReplyAll
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MessageCreateReplyAllRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Message.class);
        body = new MessageCreateReplyAllBody();
    }

    public void post(final ICallback<Message> callback) {
        send(HttpMethod.POST, callback, body);
    }

    public Message post() throws ClientException {
        return send(HttpMethod.POST, body);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IMessageCreateReplyAllRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (MessageCreateReplyAllRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IMessageCreateReplyAllRequest top(final int value) {
        getQueryOptions().add(new QueryOption("$top", value+""));
        return (MessageCreateReplyAllRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IMessageCreateReplyAllRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (MessageCreateReplyAllRequest)this;
    }

}
