// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IMicrosoftStoreForBusinessAppRequest;
import com.microsoft.graph.requests.extensions.MicrosoftStoreForBusinessAppRequest;
import com.microsoft.graph.models.extensions.MicrosoftStoreForBusinessApp;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Store For Business App Request.
 */
public class MicrosoftStoreForBusinessAppRequest extends BaseRequest implements IMicrosoftStoreForBusinessAppRequest {
	
    /**
     * The request for the MicrosoftStoreForBusinessApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftStoreForBusinessAppRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MicrosoftStoreForBusinessApp.class);
    }

    /**
     * Gets the MicrosoftStoreForBusinessApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<MicrosoftStoreForBusinessApp> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the MicrosoftStoreForBusinessApp from the service
     *
     * @return the MicrosoftStoreForBusinessApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MicrosoftStoreForBusinessApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<MicrosoftStoreForBusinessApp> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MicrosoftStoreForBusinessApp with a source
     *
     * @param sourceMicrosoftStoreForBusinessApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final MicrosoftStoreForBusinessApp sourceMicrosoftStoreForBusinessApp, final ICallback<MicrosoftStoreForBusinessApp> callback) {
        send(HttpMethod.PATCH, callback, sourceMicrosoftStoreForBusinessApp);
    }

    /**
     * Patches this MicrosoftStoreForBusinessApp with a source
     *
     * @param sourceMicrosoftStoreForBusinessApp the source object with updates
     * @return the updated MicrosoftStoreForBusinessApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MicrosoftStoreForBusinessApp patch(final MicrosoftStoreForBusinessApp sourceMicrosoftStoreForBusinessApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceMicrosoftStoreForBusinessApp);
    }

    /**
     * Creates a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp, final ICallback<MicrosoftStoreForBusinessApp> callback) {
        send(HttpMethod.POST, callback, newMicrosoftStoreForBusinessApp);
    }

    /**
     * Creates a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the new object to create
     * @return the created MicrosoftStoreForBusinessApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MicrosoftStoreForBusinessApp post(final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp) throws ClientException {
        return send(HttpMethod.POST, newMicrosoftStoreForBusinessApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IMicrosoftStoreForBusinessAppRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (MicrosoftStoreForBusinessAppRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IMicrosoftStoreForBusinessAppRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (MicrosoftStoreForBusinessAppRequest)this;
     }

}

