// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Category Collection With References Request Builder.
 */
public class MobileAppCategoryCollectionWithReferencesRequestBuilder extends BaseRequestBuilder implements IMobileAppCategoryCollectionWithReferencesRequestBuilder {

    /**
     * The request builder for this collection of MobileApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileAppCategoryCollectionWithReferencesRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IMobileAppCategoryCollectionWithReferencesRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IMobileAppCategoryCollectionWithReferencesRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new MobileAppCategoryCollectionWithReferencesRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IMobileAppCategoryWithReferenceRequestBuilder byId(final String id) {
        return new MobileAppCategoryWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IMobileAppCategoryCollectionReferenceRequestBuilder references(){
        return new MobileAppCategoryCollectionReferenceRequestBuilder(getRequestUrl() + "/$ref", getClient(), getOptions());
    }
}
