// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOnenoteOperationRequest;
import com.microsoft.graph.requests.extensions.OnenoteOperationRequest;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Operation Request Builder.
 */
public class OnenoteOperationRequestBuilder extends BaseRequestBuilder implements IOnenoteOperationRequestBuilder {

    /**
     * The request builder for the OnenoteOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenoteOperationRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IOnenoteOperationRequest instance
     */
    public IOnenoteOperationRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IOnenoteOperationRequest instance
     */
    public IOnenoteOperationRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new OnenoteOperationRequest(getRequestUrl(), getClient(), requestOptions);
    }


}

