// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Outlook Category Collection Request.
 */
public class OutlookCategoryCollectionRequest extends BaseCollectionRequest<OutlookCategoryCollectionResponse, IOutlookCategoryCollectionPage> implements IOutlookCategoryCollectionRequest {

    /**
     * The request builder for this collection of OutlookCategory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OutlookCategoryCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OutlookCategoryCollectionResponse.class, IOutlookCategoryCollectionPage.class);
    }

    public void get(final ICallback<IOutlookCategoryCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IOutlookCategoryCollectionPage get() throws ClientException {
        final OutlookCategoryCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final OutlookCategory newOutlookCategory, final ICallback<OutlookCategory> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new OutlookCategoryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newOutlookCategory, callback);
    }

    public OutlookCategory post(final OutlookCategory newOutlookCategory) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new OutlookCategoryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newOutlookCategory);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IOutlookCategoryCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (OutlookCategoryCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IOutlookCategoryCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (OutlookCategoryCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IOutlookCategoryCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (OutlookCategoryCollectionRequest)this;
    }

    public IOutlookCategoryCollectionPage buildFromResponse(final OutlookCategoryCollectionResponse response) {
        final IOutlookCategoryCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new OutlookCategoryCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final OutlookCategoryCollectionPage page = new OutlookCategoryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
