// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IPostRequest;
import com.microsoft.graph.requests.extensions.PostRequest;
import com.microsoft.graph.models.extensions.Post;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Post Request.
 */
public class PostRequest extends BaseRequest implements IPostRequest {
	
    /**
     * The request for the Post
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PostRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Post.class);
    }

    /**
     * Gets the Post from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<Post> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Post from the service
     *
     * @return the Post from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Post get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<Post> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Post with a source
     *
     * @param sourcePost the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Post sourcePost, final ICallback<Post> callback) {
        send(HttpMethod.PATCH, callback, sourcePost);
    }

    /**
     * Patches this Post with a source
     *
     * @param sourcePost the source object with updates
     * @return the updated Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Post patch(final Post sourcePost) throws ClientException {
        return send(HttpMethod.PATCH, sourcePost);
    }

    /**
     * Creates a Post with a new object
     *
     * @param newPost the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Post newPost, final ICallback<Post> callback) {
        send(HttpMethod.POST, callback, newPost);
    }

    /**
     * Creates a Post with a new object
     *
     * @param newPost the new object to create
     * @return the created Post
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Post post(final Post newPost) throws ClientException {
        return send(HttpMethod.POST, newPost);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPostRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (PostRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPostRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (PostRequest)this;
     }

}

