// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IRemoteAssistancePartnerRequest;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerRequest;
import com.microsoft.graph.requests.extensions.IRemoteAssistancePartnerBeginOnboardingRequestBuilder;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerBeginOnboardingRequestBuilder;
import com.microsoft.graph.requests.extensions.IRemoteAssistancePartnerDisconnectRequestBuilder;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerDisconnectRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Remote Assistance Partner Request Builder.
 */
public class RemoteAssistancePartnerRequestBuilder extends BaseRequestBuilder implements IRemoteAssistancePartnerRequestBuilder {

    /**
     * The request builder for the RemoteAssistancePartner
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RemoteAssistancePartnerRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IRemoteAssistancePartnerRequest instance
     */
    public IRemoteAssistancePartnerRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IRemoteAssistancePartnerRequest instance
     */
    public IRemoteAssistancePartnerRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new RemoteAssistancePartnerRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IRemoteAssistancePartnerBeginOnboardingRequestBuilder beginOnboarding() {
        return new RemoteAssistancePartnerBeginOnboardingRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.beginOnboarding"), getClient(), null);
    }

    public IRemoteAssistancePartnerDisconnectRequestBuilder disconnect() {
        return new RemoteAssistancePartnerDisconnectRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.disconnect"), getClient(), null);
    }
}

