// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IRoleAssignmentRequest;
import com.microsoft.graph.requests.extensions.RoleAssignmentRequest;
import com.microsoft.graph.requests.extensions.IRoleDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.RoleDefinitionWithReferenceRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Role Assignment Request Builder.
 */
public class RoleAssignmentRequestBuilder extends BaseRequestBuilder implements IRoleAssignmentRequestBuilder {

    /**
     * The request builder for the RoleAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RoleAssignmentRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IRoleAssignmentRequest instance
     */
    public IRoleAssignmentRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IRoleAssignmentRequest instance
     */
    public IRoleAssignmentRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new RoleAssignmentRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for RoleDefinition
     *
     * @return the IRoleDefinitionWithReferenceRequestBuilder instance
     */
    public IRoleDefinitionWithReferenceRequestBuilder roleDefinition() {
        return new RoleDefinitionWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("roleDefinition"), getClient(), null);
    }
}

