// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Terms And Conditions Collection Request.
 */
public class TermsAndConditionsCollectionRequest extends BaseCollectionRequest<TermsAndConditionsCollectionResponse, ITermsAndConditionsCollectionPage> implements ITermsAndConditionsCollectionRequest {

    /**
     * The request builder for this collection of TermsAndConditions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TermsAndConditionsCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TermsAndConditionsCollectionResponse.class, ITermsAndConditionsCollectionPage.class);
    }

    public void get(final ICallback<ITermsAndConditionsCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ITermsAndConditionsCollectionPage get() throws ClientException {
        final TermsAndConditionsCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final TermsAndConditions newTermsAndConditions, final ICallback<TermsAndConditions> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new TermsAndConditionsRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTermsAndConditions, callback);
    }

    public TermsAndConditions post(final TermsAndConditions newTermsAndConditions) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new TermsAndConditionsRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTermsAndConditions);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITermsAndConditionsCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (TermsAndConditionsCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITermsAndConditionsCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (TermsAndConditionsCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ITermsAndConditionsCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (TermsAndConditionsCollectionRequest)this;
    }

    public ITermsAndConditionsCollectionPage buildFromResponse(final TermsAndConditionsCollectionResponse response) {
        final ITermsAndConditionsCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new TermsAndConditionsCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final TermsAndConditionsCollectionPage page = new TermsAndConditionsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
