// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Collection Request Builder.
 */
public class UserCollectionRequestBuilder extends BaseRequestBuilder implements IUserCollectionRequestBuilder {

    /**
     * The request builder for this collection of User
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IUserCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IUserCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new UserCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IUserRequestBuilder byId(final String id) {
        return new UserRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }



    public IUserDeltaCollectionRequestBuilder delta() {
        return new UserDeltaCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), getClient(), null);
    }

	public IUserDeltaCollectionRequestBuilder delta(final String deltaLink) {
        return new UserDeltaCollectionRequestBuilder(deltaLink, getClient(), null);
    }
}
