/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.GroupDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.GroupDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupDeltaCollectionResponse;
import com.microsoft.graph.requests.extensions.IGroupDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IGroupDeltaCollectionRequest;
import java.util.List;

public class GroupDeltaCollectionRequest
extends BaseCollectionRequest<GroupDeltaCollectionResponse, IGroupDeltaCollectionPage>
implements IGroupDeltaCollectionRequest {
    public GroupDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupDeltaCollectionResponse.class, IGroupDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IGroupDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(GroupDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupDeltaCollectionPage get() throws ClientException {
        GroupDeltaCollectionResponse response = (GroupDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IGroupDeltaCollectionPage buildFromResponse(GroupDeltaCollectionResponse response) {
        GroupDeltaCollectionRequestBuilder builder = response.nextLink != null ? new GroupDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupDeltaCollectionPage page = new GroupDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IGroupDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IGroupDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IGroupDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

