/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.LocalizedNotificationMessage;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ILocalizedNotificationMessageCollectionPage;
import com.microsoft.graph.requests.extensions.ILocalizedNotificationMessageCollectionRequest;
import com.microsoft.graph.requests.extensions.LocalizedNotificationMessageCollectionPage;
import com.microsoft.graph.requests.extensions.LocalizedNotificationMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.LocalizedNotificationMessageCollectionResponse;
import com.microsoft.graph.requests.extensions.LocalizedNotificationMessageRequestBuilder;
import java.util.List;

public class LocalizedNotificationMessageCollectionRequest
extends BaseCollectionRequest<LocalizedNotificationMessageCollectionResponse, ILocalizedNotificationMessageCollectionPage>
implements ILocalizedNotificationMessageCollectionRequest {
    public LocalizedNotificationMessageCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, LocalizedNotificationMessageCollectionResponse.class, ILocalizedNotificationMessageCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ILocalizedNotificationMessageCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(LocalizedNotificationMessageCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ILocalizedNotificationMessageCollectionPage get() throws ClientException {
        LocalizedNotificationMessageCollectionResponse response = (LocalizedNotificationMessageCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(LocalizedNotificationMessage newLocalizedNotificationMessage, ICallback<LocalizedNotificationMessage> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new LocalizedNotificationMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newLocalizedNotificationMessage, callback);
    }

    @Override
    public LocalizedNotificationMessage post(LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new LocalizedNotificationMessageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newLocalizedNotificationMessage);
    }

    @Override
    public ILocalizedNotificationMessageCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ILocalizedNotificationMessageCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ILocalizedNotificationMessageCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ILocalizedNotificationMessageCollectionPage buildFromResponse(LocalizedNotificationMessageCollectionResponse response) {
        LocalizedNotificationMessageCollectionRequestBuilder builder = response.nextLink != null ? new LocalizedNotificationMessageCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        LocalizedNotificationMessageCollectionPage page = new LocalizedNotificationMessageCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

