// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.WorkbookApplication;
import com.microsoft.graph.models.extensions.WorkbookComment;
import com.microsoft.graph.models.extensions.WorkbookFunctions;
import com.microsoft.graph.models.extensions.WorkbookNamedItem;
import com.microsoft.graph.models.extensions.WorkbookOperation;
import com.microsoft.graph.models.extensions.WorkbookTable;
import com.microsoft.graph.models.extensions.WorkbookWorksheet;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.WorkbookCommentCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookNamedItemCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookOperationCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookTableCollectionPage;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook.
 */
public class Workbook extends Entity implements IJsonBackedObject {


    /**
     * The Application.
     * 
     */
    @SerializedName(value = "application", alternate = {"Application"})
    @Expose
    public WorkbookApplication application;

    /**
     * The Comments.
     * 
     */
    @SerializedName(value = "comments", alternate = {"Comments"})
    @Expose
    public WorkbookCommentCollectionPage comments;

    /**
     * The Functions.
     * 
     */
    @SerializedName(value = "functions", alternate = {"Functions"})
    @Expose
    public WorkbookFunctions functions;

    /**
     * The Names.
     * Represents a collection of workbook scoped named items (named ranges and constants). Read-only.
     */
    @SerializedName(value = "names", alternate = {"Names"})
    @Expose
    public WorkbookNamedItemCollectionPage names;

    /**
     * The Operations.
     * The status of workbook operations. Getting an operation collection is not supported, but you can get the status of a long-running operation if the Location header is returned in the response. Read-only.
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
    public WorkbookOperationCollectionPage operations;

    /**
     * The Tables.
     * Represents a collection of tables associated with the workbook. Read-only.
     */
    @SerializedName(value = "tables", alternate = {"Tables"})
    @Expose
    public WorkbookTableCollectionPage tables;

    /**
     * The Worksheets.
     * Represents a collection of worksheets associated with the workbook. Read-only.
     */
    @SerializedName(value = "worksheets", alternate = {"Worksheets"})
    @Expose
    public WorkbookWorksheetCollectionPage worksheets;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("comments")) {
            comments = serializer.deserializeObject(json.get("comments").toString(), WorkbookCommentCollectionPage.class);
        }

        if (json.has("names")) {
            names = serializer.deserializeObject(json.get("names").toString(), WorkbookNamedItemCollectionPage.class);
        }

        if (json.has("operations")) {
            operations = serializer.deserializeObject(json.get("operations").toString(), WorkbookOperationCollectionPage.class);
        }

        if (json.has("tables")) {
            tables = serializer.deserializeObject(json.get("tables").toString(), WorkbookTableCollectionPage.class);
        }

        if (json.has("worksheets")) {
            worksheets = serializer.deserializeObject(json.get("worksheets").toString(), WorkbookWorksheetCollectionPage.class);
        }
    }
}
