/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AdministrativeUnit;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AdministrativeUnitCollectionPage;
import com.microsoft.graph.requests.extensions.AdministrativeUnitCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AdministrativeUnitCollectionResponse;
import com.microsoft.graph.requests.extensions.AdministrativeUnitRequestBuilder;
import com.microsoft.graph.requests.extensions.IAdministrativeUnitCollectionPage;
import com.microsoft.graph.requests.extensions.IAdministrativeUnitCollectionRequest;
import java.util.List;

public class AdministrativeUnitCollectionRequest
extends BaseCollectionRequest<AdministrativeUnitCollectionResponse, IAdministrativeUnitCollectionPage>
implements IAdministrativeUnitCollectionRequest {
    public AdministrativeUnitCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AdministrativeUnitCollectionResponse.class, IAdministrativeUnitCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAdministrativeUnitCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AdministrativeUnitCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAdministrativeUnitCollectionPage get() throws ClientException {
        AdministrativeUnitCollectionResponse response = (AdministrativeUnitCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AdministrativeUnit newAdministrativeUnit, ICallback<? super AdministrativeUnit> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AdministrativeUnitRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAdministrativeUnit, callback);
    }

    @Override
    public AdministrativeUnit post(AdministrativeUnit newAdministrativeUnit) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AdministrativeUnitRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAdministrativeUnit);
    }

    @Override
    public IAdministrativeUnitCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAdministrativeUnitCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAdministrativeUnitCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAdministrativeUnitCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAdministrativeUnitCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAdministrativeUnitCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAdministrativeUnitCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAdministrativeUnitCollectionPage buildFromResponse(AdministrativeUnitCollectionResponse response) {
        AdministrativeUnitCollectionRequestBuilder builder = response.nextLink != null ? new AdministrativeUnitCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AdministrativeUnitCollectionPage page = new AdministrativeUnitCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

