/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AuthenticationMethodConfiguration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AuthenticationMethodConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.AuthenticationMethodConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AuthenticationMethodConfigurationCollectionResponse;
import com.microsoft.graph.requests.extensions.AuthenticationMethodConfigurationRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodConfigurationCollectionRequest;
import java.util.List;

public class AuthenticationMethodConfigurationCollectionRequest
extends BaseCollectionRequest<AuthenticationMethodConfigurationCollectionResponse, IAuthenticationMethodConfigurationCollectionPage>
implements IAuthenticationMethodConfigurationCollectionRequest {
    public AuthenticationMethodConfigurationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodConfigurationCollectionResponse.class, IAuthenticationMethodConfigurationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAuthenticationMethodConfigurationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AuthenticationMethodConfigurationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionPage get() throws ClientException {
        AuthenticationMethodConfigurationCollectionResponse response = (AuthenticationMethodConfigurationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AuthenticationMethodConfiguration newAuthenticationMethodConfiguration, ICallback<? super AuthenticationMethodConfiguration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AuthenticationMethodConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthenticationMethodConfiguration, callback);
    }

    @Override
    public AuthenticationMethodConfiguration post(AuthenticationMethodConfiguration newAuthenticationMethodConfiguration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AuthenticationMethodConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthenticationMethodConfiguration);
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAuthenticationMethodConfigurationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAuthenticationMethodConfigurationCollectionPage buildFromResponse(AuthenticationMethodConfigurationCollectionResponse response) {
        AuthenticationMethodConfigurationCollectionRequestBuilder builder = response.nextLink != null ? new AuthenticationMethodConfigurationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AuthenticationMethodConfigurationCollectionPage page = new AuthenticationMethodConfigurationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

