/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Calendar;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CalendarCollectionPage;
import com.microsoft.graph.requests.extensions.CalendarCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CalendarCollectionResponse;
import com.microsoft.graph.requests.extensions.CalendarRequestBuilder;
import com.microsoft.graph.requests.extensions.ICalendarCollectionPage;
import com.microsoft.graph.requests.extensions.ICalendarCollectionRequest;
import java.util.List;

public class CalendarCollectionRequest
extends BaseCollectionRequest<CalendarCollectionResponse, ICalendarCollectionPage>
implements ICalendarCollectionRequest {
    public CalendarCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CalendarCollectionResponse.class, ICalendarCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ICalendarCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CalendarCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICalendarCollectionPage get() throws ClientException {
        CalendarCollectionResponse response = (CalendarCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Calendar newCalendar, ICallback<? super Calendar> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CalendarRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCalendar, callback);
    }

    @Override
    public Calendar post(Calendar newCalendar) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CalendarRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCalendar);
    }

    @Override
    public ICalendarCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ICalendarCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ICalendarCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ICalendarCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICalendarCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ICalendarCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ICalendarCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ICalendarCollectionPage buildFromResponse(CalendarCollectionResponse response) {
        CalendarCollectionRequestBuilder builder = response.nextLink != null ? new CalendarCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CalendarCollectionPage page = new CalendarCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

