/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Channel;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IChannelRequest;
import java.util.List;

public class ChannelRequest
extends BaseRequest
implements IChannelRequest {
    public ChannelRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Channel.class);
    }

    @Override
    public void get(ICallback<? super Channel> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Channel get() throws ClientException {
        return (Channel)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Channel> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Channel sourceChannel, ICallback<? super Channel> callback) {
        this.send(HttpMethod.PATCH, callback, sourceChannel);
    }

    @Override
    public Channel patch(Channel sourceChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.PATCH, sourceChannel);
    }

    @Override
    public void post(Channel newChannel, ICallback<? super Channel> callback) {
        this.send(HttpMethod.POST, callback, newChannel);
    }

    @Override
    public Channel post(Channel newChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.POST, newChannel);
    }

    @Override
    public void put(Channel newChannel, ICallback<? super Channel> callback) {
        this.send(HttpMethod.PUT, callback, newChannel);
    }

    @Override
    public Channel put(Channel newChannel) throws ClientException {
        return (Channel)this.send(HttpMethod.PUT, newChannel);
    }

    @Override
    public IChannelRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChannelRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

